<?php 
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

$error_message = "";
if (isset($_SESSION['error'])) {
    $error_message = $_SESSION['error'];
    unset($_SESSION['error']);
}
?>
<!DOCTYPE html>
<html lang="en">
    <head>
    <?php $title = "Change Password";
    include 'partials/title-meta.php'; ?>

		<?php include 'partials/head-css.php'; ?>

    </head>

    <body class="loading authentication-bg authentication-bg-pattern">

        <div class="account-pages my-5">
            <div class="container">

                <div class="row justify-content-center">
                    <div class="col-md-8 col-lg-6 col-xl-4">
                        <div class="text-center">   
                            <a href="index.php">
                                <img src="assets/images/faida-logo.png" alt="" height="40" class="mx-auto">
                            </a>
                            <p class="text-muted mt-2 mb-4">Change Password - Faida System</p>

                        </div>
                        
                        <div class="card">
                    <div class="card-body p-4">
                        <!-- Change Password Form -->
                        <form id="changePasswordForm" method="POST" action="change_password_process.php">
                            <!-- Current Password Input -->
                            <div class="mb-3">
                                <label for="currentPassword" class="form-label">Current Password</label>
                                <input class="form-control" type="password" id="currentPassword" name="currentPassword" placeholder="Enter your current password" required>
                            </div>

                            <!-- New Password Input -->
                            <div class="mb-3">
                                <label for="newPassword" class="form-label">New Password</label>
                                <input class="form-control" type="password" id="newPassword" name="newPassword" placeholder="Enter your new password" required>
                            </div>

                            <!-- Confirm New Password Input -->
                            <div class="mb-3">
                                <label for="confirmPassword" class="form-label">Confirm New Password</label>
                                <input class="form-control" type="password" id="confirmPassword" name="confirmPassword" placeholder="Confirm your new password" required>
                            </div>

                            <div id="errorMessage" style="color:red;"><?php echo $error_message; ?></div>

                            <!-- Submit Button -->
                            <div class="mb-3 d-grid text-center">
                                <button class="btn btn-primary" type="submit">Change Password</button>
                            </div>
                        </form>
                    </div> <!-- end card-body -->
                </div>
                <!-- end card -->

                    </div> <!-- end col -->
                </div>
                <!-- end row -->
            </div>
            <!-- end container -->
        </div>
        <!-- end page -->

        <?php include 'partials/footer-scripts.php'; ?>

        <!-- App js -->
        <script src="assets/js/app.min.js"></script>
        <script>
            document.getElementById('changePasswordForm').addEventListener('submit', function(event) {
                var newPassword = document.getElementById('newPassword').value;
                var confirmPassword = document.getElementById('confirmPassword').value;
                var errorMessage = document.getElementById('errorMessage');

                if (newPassword !== confirmPassword) {
                    errorMessage.textContent = "New passwords do not match.";
                    event.preventDefault();
                    return false;
                }
            });
        </script>
    </body>
</html>
