<?php
require_once 'includes/dbconn.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $expense_name = $_POST["expense_name"];
    $category = $_POST["category"]; // This will be the account_id from the dropdown
    $expense_date = $_POST["expense_date"];
    $description = $_POST["description"];
    $amount = $_POST["amount"];
    $user_id = $_SESSION["user_id"]; // or however you get the user_id
    $company_id = $_SESSION["company_id"]; // make sure the company_id is stored in session or POST data
    $capture_date = date('Y-m-d H:i:s');

    // Prepared statement to insert expense data
    $stmt = $conn->prepare("INSERT INTO expenses (expense_name, category, expense_date, description, amount, user_id, capture_date, company_id) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("sisssiss", $expense_name, $category, $expense_date, $description, $amount, $user_id, $capture_date, $company_id);

    if ($stmt->execute()) {
        // Redirect or give success message
        header("Location: ".$_SERVER['HTTP_REFERER']);
        exit();
    } else {
        // Error handling
        echo "Error: " . $stmt->error;
    }

    $stmt->close();
} else {
    // Form not submitted handling
    echo "Form not submitted.";
}

$conn->close();
?>
