<?php
// This function generates a date condition based on the option provided.
function getDateCondition($option, $dateColumn) {
    switch ($option) {
        case 'daily':
            return "$dateColumn = CURDATE()";
        case 'weekly':
            // Assumes the week starts on Monday.
            return "$dateColumn >= DATE_SUB(CURDATE(), INTERVAL WEEKDAY(CURDATE()) DAY)";
        case 'monthly':
            return "MONTH($dateColumn) = MONTH(CURDATE()) AND YEAR($dateColumn) = YEAR(CURDATE())";
        default:
            return "$dateColumn = CURDATE()";
    }
}
?>
