<?php
// Include necessary files and configurations
session_start();

// Include database connection file
include('includes/dbconn.php');

?>

<!DOCTYPE html>
<html lang="en">

<head>

    <?php
    $title = "Create Client Transaction";
    include 'partials/title-meta.php';
    ?>

    <link href="assets/libs/mohithg-switchery/switchery.min.css" rel="stylesheet" type="text/css" />
    <link href="assets/libs/multiselect/css/multi-select.css" rel="stylesheet" type="text/css" />
    <link href="assets/libs/select2/css/select2.min.css" rel="stylesheet" type="text/css" />
    <link href="assets/libs/selectize/css/selectize.bootstrap3.css" rel="stylesheet" type="text/css" />
    <link href="assets/libs/bootstrap-touchspin/jquery.bootstrap-touchspin.min.css" rel="stylesheet" type="text/css" />

    <?php
    include 'partials/head-css.php';
    ?>

</head>

<?php
include 'partials/body.php';
?>

<!-- Begin page -->
<div id="wrapper">

    <?php
    $pagetitle = "Create Client Transaction";
    include 'partials/menu.php';
    ?>

    <!-- ============================================================== -->
    <!-- Start Page Content here -->
    <!-- ============================================================== -->

    <div class="content-page">
        <div class="content">

            <!-- Start Content-->
            <div class="container-fluid">

                <div class="card">
                    <div class="card-body">
                        <h4 class="header-title">Create Client Transaction</h4>
                        <p class="sub-header">Capture client transaction.</p>

                        <form class="needs-validation" novalidate action="submit_transaction.php" method="post">
                            <div class="row">
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label for="account_id" class="form-label">Account:</label>
                                        <select class="form-control" name="account_id" id="account_id" required>
                                            <?php
                                            $query = "SELECT account_id, account_name FROM chart_of_accounts WHERE company_id = 1";
                                            $stmt = $conn->prepare($query);
                                            $stmt->bind_param("i", $_SESSION['company_id']);
                                            $stmt->execute();
                                            $result = $stmt->get_result();
                                            
                                            while ($row = $result->fetch_assoc()) {
                                                echo "<option value='" . $row['account_id'] . "'>" . $row['account_name'] . "</option>";
                                            }
                                            ?>
                                        </select>

                                    </div>
                                    <div class="mb-3">
                                        <label for="type" class="form-label">Transaction Type:</label>
                                        <select class="form-control" id="type" name="type" required>    
                                            <option value="Debit">Debit</option>
                                            <option value="Credit">Credit</option>
                                        </select>
                                    </div>
                                    <div class="mb-3">
                                        <label for="amount" class="form-label">Amount:</label>
                                        <input type="number" class="form-control" id="amount" name="amount" step="0.01" placeholder="Amount" required />
                                    </div>
                                </div>

                                <div class="col-lg-6">

                                    
                                    <div class="mb-3">
                                        <label for="date" class="form-label">Date:</label>
                                        <input type="date" class="form-control" id="date" name="date" required />
                                    </div>

                                    <!-- Invoice Line Items -->
                                    <div class="mb-3">
                                        <label for="description" class="form-label">Description (Optional):</label>
                                        <textarea class="form-control" id="description" name="description" placeholder="Description" required></textarea>
                                    </div>
                                    <input type="hidden" name="company_id" value="<?php echo htmlspecialchars($_SESSION['company_id']); ?>">
                                </div>
                            </div>

                            <button class="btn btn-primary" type="submit">Submit Transaction</button>
                        </form>

                    </div> <!-- end card-body-->
                </div> <!-- end card-->

            </div> <!-- container -->

        </div> <!-- content -->

        <?php
        include 'partials/footer.php';
        ?>

    </div>

    <!-- ============================================================== -->
    <!-- End Page content -->
    <!-- ============================================================== -->

</div>
<!-- END wrapper -->

<?php
include 'partials/right-sidebar.php';
?>

<?php
include 'partials/footer-scripts.php';
?>

<!-- Plugin js-->
<script src="assets/libs/parsleyjs/parsley.min.js"></script>

<!-- Validation init js-->
<script src="assets/js/pages/form-validation.init.js"></script>

<!-- App js -->
<script src="assets/js/app.min.js"></script>
<script src="assets/libs/selectize/js/standalone/selectize.min.js"></script>
<script src="assets/libs/mohithg-switchery/switchery.min.js"></script>
<script src="assets/libs/multiselect/js/jquery.multi-select.js"></script>
<script src="assets/libs/select2/js/select2.min.js"></script>
<script src="assets/libs/jquery-mockjax/jquery.mockjax.min.js"></script>
<script src="assets/libs/devbridge-autocomplete/jquery.autocomplete.min.js"></script>
<script src="assets/libs/bootstrap-touchspin/jquery.bootstrap-touchspin.min.js"></script>
<script src="assets/libs/bootstrap-maxlength/bootstrap-maxlength.min.js"></script>
<script>
    $(document).ready(function() {
        $('#client_name').select2();
    });
</script>
<script>
function calculateTotal() {
    var quantity = document.getElementById('quantity').value;
    var unitPrice = document.getElementById('unit_price').value;
    var total = quantity * unitPrice;
    
    document.getElementById('total_amount').value = total.toFixed(2); // Set total amount with two decimal places
}
</script>

<script>
    // Get today's date
    var today = new Date();

    // Format it as YYYY-MM-DD (which is the format commonly used in databases)
    var formattedDate = today.toISOString().substr(0, 10);

    // Set the default value of the input field to today's date
    document.getElementById("start_date").value = formattedDate;
</script>

</body>

</html>
