<!DOCTYPE html>
<html lang="en">
    <head>
    <?php $title = "Log In";
    include 'partials/title-meta.php'; ?>

		<?php include 'partials/head-css.php'; ?>

    </head>

    <body class="loading authentication-bg authentication-bg-pattern">

        <div class="account-pages my-5">
            <div class="container">

                <div class="row justify-content-center">
                    <div class="col-md-8 col-lg-6 col-xl-4">
                        <div class="text-center">   
                            <a href="index.php">
                                <img src="assets/images/faida-logo.png" alt="" height="40" class="mx-auto">
                            </a>
                            <p class="text-muted mt-2 mb-4">Faida System</p>

                        </div>
                        
                        <div class="card">
                    <div class="card-body p-4">
                        <!-- Login Form -->
                        <form id="loginForm" method="POST" action="login_process.php">
                            <!-- Email Input -->
                            <div class="mb-3">
                                <label for="emailaddress" class="form-label">Email address</label>
                                <input class="form-control" type="email" id="emailaddress" name="email" placeholder="Enter your email">
                            </div>

                            <!-- Password Input -->
                            <div class="mb-3">
                                <label for="password" class="form-label">Password</label>
                                <input class="form-control" type="password" id="password" name="password" placeholder="Enter your password">
                            </div>

                            <div id="errorMessage" style="color:red;"></div>

                            <!-- Submit Button -->
                            <div class="mb-3 d-grid text-center">
                                <button class="btn btn-primary" type="button" onclick="validateForm()">Log In</button>
                            </div>
                        </form>
                    </div> <!-- end card-body -->
                </div>
                <!-- end card -->

                        <div class="row mt-3">
                            <div class="col-12 text-center">
                                <p> <a href="auth-recoverpw.php" class="text-muted ms-1"><i class="fa fa-lock me-1"></i>Forgot your password?</a></p>
                                <p class="text-muted">Don't have an account? <a href="auth-register.php" class="text-dark ms-1"><b>Sign Up</b></a></p>
                            </div> <!-- end col -->
                        </div>
                        <!-- end row -->

                    </div> <!-- end col -->
                </div>
                <!-- end row -->
            </div>
            <!-- end container -->
        </div>
        <!-- end page -->

        <?php include 'partials/footer-scripts.php'; ?>

        <!-- App js -->
        <script src="assets/js/app.min.js"></script>
        <script>
            function validateForm() {
                var email = document.getElementById('emailaddress').value;
                var password = document.getElementById('password').value;
                var errorMessage = document.getElementById('errorMessage');

                if (email === "" || password === "") {
                    errorMessage.textContent = "Please enter both email and password.";
                    return false;
                }

                // If validation passes, submit the form
                document.getElementById('loginForm').submit();
            }
        </script>
    </body>
</html>